function test_suite = testLdivide %#ok<STOUT>
initTestSuite;

function testZeroDividedByReal %#ok<*DEFNU>
x = polysym(0);
y = polysym(rand);
z = y.\x;
assertTrue(z.Value=='0');

function testZeroDividedByChar
x = polysym(0);
y = polysym('y');
z = y.\x;
assertTrue(z.Value=='0');

function testZeroDividedByZero
x = polysym(0);
f = @() 0.\x;
assertExceptionThrown(f,'polysym:ldivide:DivideByZero')

function testCharDividedByZero
x = polysym('x');
f = @() 0.\x;
assertExceptionThrown(f,'polysym:ldivide:DivideByZero')

function testCharDividedByInteger
x = polysym('x');
z = 5.\x;
assertEqual(z.Value,'x/5');

function testCharDividedByReal
x = polysym('x');
y = polysym(pi);
z = y.\x;
assertEqual(z.Value,['x/',y.Value]);

function testRealDividedByChar
x = polysym(pi);
y = polysym('y');
z = y.\x;
assertEqual(z.Value,[x.Value,'/y']);

% From documentation: If either OBJ1 or OBJ2 is a scalar, it is expanded to
% an array of the same dimensions as the other input.
function testScalarDividedByVector
x = polysym('x');
y = polysym(1:3);
z = y.\x;
assertEqual(z(1).Value,'x');
assertEqual(z(2).Value,'x/2');
assertEqual(z(3).Value,'x/3');


function testVectorDividedByVector
x = polysym({'x','y'});
y = polysym({'u','w'});
z = y.\x;
assertEqual(z(1).Value,'x/u');
assertEqual(z(2).Value,'y/w');

function testDivDiv
% NOTE: This result is undesirable.
x = polysym('x');
y = polysym('4/y');
z = y.\x;
assertEqual(z.Value,'x/4/y');
